/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_and_space;

import java.util.concurrent.CompletableFuture;
import mrthomas20121.thermal_and_space.datagen.SpaceBlockStateProvider;
import mrthomas20121.thermal_and_space.datagen.SpaceItemModelProvider;
import mrthomas20121.thermal_and_space.datagen.SpaceLangProvider;
import mrthomas20121.thermal_and_space.datagen.SpaceLootGen;
import mrthomas20121.thermal_and_space.datagen.SpaceRegistrySets;
import mrthomas20121.thermal_and_space.datagen.SpaceTagsProvider;
import mrthomas20121.thermal_and_space.init.SpaceBlocks;
import mrthomas20121.thermal_and_space.init.SpaceCreativeTabs;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal_and_space")
@Mod.EventBusSubscriber(modid="thermal_and_space", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThermalAndSpace {
    public static final String MOD_ID = "thermal_and_space";
    public static final Logger LOGGER = LogManager.getLogger();

    public ThermalAndSpace() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SpaceBlocks.BLOCKS.register(bus);
        SpaceBlocks.ITEMS.register(bus);
        SpaceCreativeTabs.CREATIVE_TABS.register(bus);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PackOutput packOutput = gen.getPackOutput();
        SpaceTagsProvider.Block block = new SpaceTagsProvider.Block(packOutput, lookupProvider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)block);
        gen.addProvider(event.includeServer(), (DataProvider)new SpaceTagsProvider.Item(packOutput, lookupProvider, block, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new SpaceLangProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new SpaceBlockStateProvider(packOutput, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new SpaceItemModelProvider(packOutput, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new SpaceRegistrySets(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new SpaceLootGen(gen.getPackOutput()));
    }
}

